(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16539,        423]
NotebookOptionsPosition[     15486,        397]
NotebookOutlinePosition[     15822,        412]
CellTagsIndexPosition[     15779,        409]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "average", " ", "front", " ", "time", " ", "trace"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "80"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"analysis", "=", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{"\"\<pars_\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
         "\"\</rng_\>\"", "<>", 
         RowBox[{"ToString", "[", "k", "]"}], "<>", "\"\</Analysis.h5\>\""}], 
        ",", "\"\</FrontPosition\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", 
         RowBox[{"(", 
          RowBox[{"\"\<Variance\>\"", "+", 
           RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cfg", "+=", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
        RowBox[{"(", 
         RowBox[{"\"\<CELL\>\"", "/.", 
          RowBox[{"Import", "[", 
           RowBox[{"\"\<pars_\>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
            "\"\</rng_\>\"", "<>", 
            RowBox[{"ToString", "[", "k", "]"}], "<>", 
            "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
   RowBox[{
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "/=", "100"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.7498187558942633`*^9, {3.749818787198708*^9, 3.7498187886729193`*^9}, {
   3.751371489442762*^9, 3.7513714926886587`*^9}, {3.752034507847204*^9, 
   3.752034511003223*^9}, {3.776537383637834*^9, 
   3.776537426738244*^9}},ExpressionUUID->"c9c001ea-12bd-4102-bb53-\
5547682c7cc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "polarization", " ", "value"}], " ", "*)"}], 
  "\[IndentingNewLine]", "cfg"}]], "Input",
 CellChangeTimes->{{3.7498189694374866`*^9, 3.749818969825807*^9}, {
  3.7765373921048107`*^9, 
  3.776537440472007*^9}},ExpressionUUID->"eb8b695e-1d84-4f58-8fca-\
8d3f3dae3d00"],

Cell[BoxData["62.`"], "Output",
 CellChangeTimes->{{3.74981897094456*^9, 3.7498190061231213`*^9}, {
  3.7499839737541733`*^9, 3.749984045341154*^9}, {3.751371484651697*^9, 
  3.751371557438506*^9}, {3.752034514352384*^9, 3.7520345610123158`*^9}},
 CellLabel->"Out[70]=",ExpressionUUID->"9377b1f3-14eb-433f-8156-29732165f408"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "time", " ", "trace"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_Q_62.dat\>\"", ",", "result"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.749818942527513*^9, 3.749819016898625*^9}, {
  3.749983983699026*^9, 3.749984044253263*^9}, {3.7513714977171717`*^9, 
  3.7513715001117077`*^9}, {3.751371532582006*^9, 3.75137155917213*^9}, {
  3.7520345140225*^9, 3.752034558060781*^9}, {3.776537446340625*^9, 
  3.7765374469572563`*^9}},ExpressionUUID->"860367a0-f66b-4b75-bbfc-\
60a83db59b38"],

Cell[BoxData["\<\"~/Downloads/tissue_Q_62.dat\"\>"], "Output",
 CellChangeTimes->{{3.7498189632432756`*^9, 3.7498190203662443`*^9}, {
   3.749983986550441*^9, 3.7499840454589663`*^9}, 3.7513715004827433`*^9, {
   3.751371533195045*^9, 3.7513715596300993`*^9}, {3.752034520060802*^9, 
   3.7520345625942307`*^9}},
 CellLabel->"Out[71]=",ExpressionUUID->"64602b61-6f76-4e86-bf81-49f91e8bce52"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "tissue", " ", "properties", " ", "depending", " ", "on", " ", 
    "cell", " ", "polarizability"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resultarray", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"finalresult", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cfg", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"analysis", "=", 
            RowBox[{"Import", "[", 
             RowBox[{
              RowBox[{"\"\<pars_\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
               "\"\</rng_\>\"", "<>", 
               RowBox[{"ToString", "[", "k", "]"}], "<>", 
               "\"\</Analysis.h5\>\""}], ",", "\"\</FrontPosition\>\""}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", 
               RowBox[{"(", 
                RowBox[{"\"\<Variance\>\"", "+", 
                 RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"cfg", "+=", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
              RowBox[{"(", 
               RowBox[{"\"\<CELL\>\"", "/.", 
                RowBox[{"Import", "[", 
                 RowBox[{"\"\<pars_\>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{
                    RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
                  "\"\</rng_\>\"", "<>", 
                  RowBox[{"ToString", "[", "k", "]"}], "<>", 
                  "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
          "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
         RowBox[{
          RowBox[{"result", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cfg", "/=", "100"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"resultarray", ",", "result"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"cfg", ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"Mean", "[", 
           RowBox[{
            RowBox[{"Sqrt", "@", 
             RowBox[{"result", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"200", ";;", 
                 RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], "/", 
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"200", ";;", 
                RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], "]"}]}], 
         "}"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "0", ",", "99"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n", ",", "k"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7469611432785597`*^9, 3.746961144276451*^9}, {
   3.746965281869259*^9, 3.746965459873785*^9}, {3.746965498987928*^9, 
   3.746965667889323*^9}, {3.7469748860070477`*^9, 3.74697491872473*^9}, {
   3.746974949416271*^9, 3.7469750794926558`*^9}, {3.7469751268254347`*^9, 
   3.746975131510262*^9}, {3.746975184142248*^9, 3.746975208871375*^9}, {
   3.7469752432553988`*^9, 3.7469752435576773`*^9}, {3.746975275545196*^9, 
   3.746975300213953*^9}, {3.746975811139539*^9, 3.746975835250311*^9}, {
   3.747295250876471*^9, 3.7472952543825197`*^9}, {3.7472953335387707`*^9, 
   3.7472954302408648`*^9}, {3.74729549143955*^9, 3.747295505649798*^9}, {
   3.7472955479207067`*^9, 3.7472955700068283`*^9}, {3.747295608263852*^9, 
   3.747295624632111*^9}, {3.747295696061473*^9, 3.7472957039784718`*^9}, {
   3.747295856557472*^9, 3.7472958576972857`*^9}, {3.747462376603374*^9, 
   3.7474623972365522`*^9}, {3.7475423561524973`*^9, 3.747542360860826*^9}, {
   3.749484816344467*^9, 3.74948482186034*^9}, {3.749484912770645*^9, 
   3.749485064468494*^9}, {3.7494854510000553`*^9, 3.749485454495776*^9}, {
   3.7494855579559803`*^9, 3.749485558916917*^9}, {3.749485598799759*^9, 
   3.749485604805133*^9}, 3.7495270040525913`*^9, {3.749993286865794*^9, 
   3.7499933038901787`*^9}, {3.7513635821639853`*^9, 3.751363597089436*^9}, 
   3.7520332060935783`*^9, {3.776537406668425*^9, 3.776537426744071*^9}, {
   3.7765374615336113`*^9, 
   3.776537501862549*^9}},ExpressionUUID->"4fcce424-4313-4a2d-877b-\
803122798cb3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "cell", " ", "polarizability", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"non", "-", "specific"}], ";", " ", 
      RowBox[{
      "to", " ", "get", " ", "the", " ", "specific", " ", "polarizability", 
       " ", "divide", " ", "by", " ", "membrane", " ", 
       RowBox[{"stiffness", "!"}]}]}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "maximum", " ", "expansion"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "maximum", " ", "variance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "average", " ", "roughness", " ", 
    RowBox[{"(", 
     RowBox[{
     "standard", " ", "deviation", " ", "relative", " ", "to", " ", 
      "expanion"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_Q.dat\>\"", ",", "finalresult"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7474636050837317`*^9, 3.747463613504825*^9}, {
  3.747463657079228*^9, 3.747463667162775*^9}, {3.7495269934278727`*^9, 
  3.74952699366398*^9}, {3.7513714638387213`*^9, 3.751371464111505*^9}, {
  3.752033225956875*^9, 3.75203322617733*^9}, {3.7765375099002523`*^9, 
  3.7765375516879187`*^9}},ExpressionUUID->"1cd23770-9341-46f0-9e68-\
a2f83469e71d"],

Cell[BoxData["\<\"~/Downloads/tissue_Q.dat\"\>"], "Output",
 CellChangeTimes->{3.747463667700366*^9, 3.749527593185503*^9, 
  3.749983962022409*^9, 3.74999408225817*^9, 3.749994306990736*^9, 
  3.751371464589746*^9, 3.752033857295545*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"d2e63a2e-2454-4b60-ac2e-730edcd06c58"]
}, Open  ]]
},
WindowSize->{808, 656},
WindowMargins->{{Automatic, 0}, {Automatic, 29}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3999, 114, 451, "Input",ExpressionUUID->"c9c001ea-12bd-4102-bb53-5547682c7cc1"],
Cell[CellGroupData[{
Cell[4582, 138, 337, 8, 52, "Input",ExpressionUUID->"eb8b695e-1d84-4f58-8fca-8d3f3dae3d00"],
Cell[4922, 148, 325, 4, 34, "Output",ExpressionUUID->"9377b1f3-14eb-433f-8156-29732165f408"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5284, 157, 614, 13, 52, "Input",ExpressionUUID->"860367a0-f66b-4b75-bbfc-60a83db59b38"],
Cell[5901, 172, 391, 5, 34, "Output",ExpressionUUID->"64602b61-6f76-4e86-bf81-49f91e8bce52"]
}, Open  ]],
Cell[6307, 180, 7334, 170, 598, "Input",ExpressionUUID->"4fcce424-4313-4a2d-877b-803122798cb3"],
Cell[CellGroupData[{
Cell[13666, 354, 1484, 34, 157, "Input",ExpressionUUID->"1cd23770-9341-46f0-9e68-a2f83469e71d"],
Cell[15153, 390, 317, 4, 34, "Output",ExpressionUUID->"d2e63a2e-2454-4b60-ac2e-730edcd06c58"]
}, Open  ]]
}
]
*)

